//  Listing 10.4. Funkcje dokonujce przecienia operatorw. Definicje funkcji operatorowych poza definicj klasy


#include <iostream>
using namespace std;

class Complex             	// typ zdefiniowany przez programist
{                         	// pocztek klasy Complex
double real, imag;       	// prywatne pola danych
public:                   	// publiczne metody
Complex(double r, double i); 	// konstruktor oglny
	// sowo const, bo obiekt docelowy nie bdzie modyfikowany
Complex operator+(const Complex &b) const; 
	// tu obiekt docelowy zostanie zmodyfikowany
void operator += (const Complex &b); 
	// tu obiekt docelowy zostanie zmodyfikowany
void operator += (double b); 
	// obiekt docelowy nie zostanie zmodyfikowany
void operator + () const; 
} ;                   		// koniec klasy Complex

Complex::Complex(double r, double i) 	// konstruktor oglny
{ 
  real =r; 
  imag = i; 
}

Complex Complex::operator+(const Complex &b) const
{ 
  return Complex (real + b.real, imag + b.imag); 
}

	// nastpujca funkcja zmodyfikuje obiekt docelowy
void Complex::operator += (const Complex &b) 
{ 
  real = real + b.real; 		// dodajemy cz rzeczywist do obiektu docelowego
  imag = imag + b.imag; 		// dodajemy cz urojon do obiektu docelowego
} 
	// nastpujca funkcja zmodyfikuje obiekt docelowy
void Complex::operator += (double b) 
{ 
  real += b; 	 			// dodajemy cz rzeczywist do obiektu docelowego
}

void Complex::operator + () const 	// obiekt docelowy bez zmian
{ 
  cout << "(" << real << ", " << imag << ")" << endl; 
}

int main()
{ 
  Complex x(20,40), y(30,50), z1(0,0), z2(0,0); 	// obiekty zainicjowane
  cout << " Warto zmiennej x: "; +x; 			// to samo, co  x.operator+();
  cout << " Warto zmiennej y: "; y.operator+(); 	// wydruk rezultatu
  z1 = x.operator+(y); 					// uycie w wywoaniu funkcji
  cout << " z1 = x + y: "; +z1;
  z2 = x + y; 						// to samo, co z2=x.operator+(y);
  cout << " z2 = x + y: "; +z2;
  z1 += x; 						// to samo, co z1.operator+=(x);
  cout << " Dodajemy x do z1: "; +z1;
  z2 += 30.0; 						// to samo, co z2.operator+=(30.0);
  cout << " Dodajemy 30 do z2: "; +z2;
  return 0;
}
